VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3960
   ClientLeft      =   2340
   ClientTop       =   1590
   ClientWidth     =   4860
   LinkTopic       =   "Form1"
   ScaleHeight     =   3960
   ScaleWidth      =   4860
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop AO"
      Enabled         =   0   'False
      Height          =   375
      Left            =   960
      TabIndex        =   3
      Top             =   1920
      Width           =   1695
   End
   Begin VB.CommandButton cmdSample 
      Caption         =   "Start Continuous AO"
      Enabled         =   0   'False
      Height          =   375
      Left            =   960
      TabIndex        =   1
      Top             =   1320
      Width           =   1695
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize Device 0"
      Height          =   375
      Left            =   960
      TabIndex        =   0
      Top             =   720
      Width           =   1695
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   240
      Top             =   600
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   240
      Top             =   1320
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label3 
      Caption         =   "Data are written at 1 KHz rate.  Look for Square Wave on DAC 0 and a Sine Wave on DAC 1."
      Height          =   495
      Left            =   600
      TabIndex        =   5
      Top             =   3120
      Width           =   3495
   End
   Begin VB.Label Label2 
      BackColor       =   &H8000000E&
      Height          =   255
      Left            =   960
      TabIndex        =   4
      Top             =   2520
      Width           =   2055
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   " KEITHLEY "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   300
      Left            =   960
      TabIndex        =   2
      Top             =   120
      Width           =   1455
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit ' require variable declaration
' allocate array for the data and some other variables that will be needed
Const bufSize As Long = 1000  ' make this an even number please
Dim AOData() As Single  ' will size this later
Dim dummy As Single
Dim i As Long
' this example was written with a KPCI-3108 in Win2K SP1
' using VB6 and 3108-850A04 version of DriverLINX
'
' it programs a squarewave on DAC channel 0 and a sine wave on DAC channel 1
' it writes this data using burst mode at 1 KHz
' burst mode means for each tic of the 1KHz clock, both channels are updated.

Private Sub cmdInit_Click()
' open the driver and initialize the hardware
With SR
.Req_DLL_name = "kpci3108$"  ' give driver name to avoid Open DriverLINX dialog
.Req_device = 0
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
' use of the LDD control is not required
If SR.Res_result = DL_NoErr Then
cmdSample.Enabled = True
cmdInit.Enabled = False
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device
LDD.Refresh
Form1.Caption = "Buffered AO with " & LDD.Dev_Model 'from the LDD, determine the model number
Else
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
End If
' the LDD control can inform your application
' about the features of the hardware
Form1.SetFocus
End Sub

Private Sub cmdSample_Click()

SetupAInonStop  ' set up most of the task.....
'
' load the 3 buffers with data
ReDim AOData(bufSize)  ' make the array equal in size to the buffer
Dim AOChan0(bufSize / 2) As Single  ' sure hope it is always even number!
Dim AOChan1(bufSize / 2) As Single
' step 1, load AOChan arrays with voltage data equal to
' half the size of the buffer that AO task will use
For i = 0 To ((bufSize / 2) - 1)
'AOChan0(i) = 5 * Sin(2 * 3.142857 * i / ((bufSize / 2) - 1))
AOChan0(i) = (i And 1) * 5
Next i
' now load chan 1
For i = 0 To ((bufSize / 2) - 1)
AOChan1(i) = 2.5 * Cos(2 * 3.142857 * i / ((bufSize / 2) - 1))
Next i
' step 2, interleave the memory buffers with these values from the two DAC channels
For i = 0 To (bufSize / 2 - 1)
AOData(2 * i) = AOChan0(i)       ' even number are for AO chan 0
AOData(2 * i + 1) = AOChan1(i)   ' odd number are for AO chan 1
Next i

' next move these interleaved arrays to the driver's memory buffers
Dim bufIndex As Integer
For bufIndex = 0 To 2
dummy = SR.VBArrayBufferConvert(bufIndex, 0, bufSize, AOData, DL_tSINGLE, 0, 0)
Next bufIndex
' now start the task
SR.Refresh  ' start the task
' error check
SR.Req_op = DL_MESSAGEBOX
SR.Refresh
' see Private Sub SR_BufferFilled() for what happens next
If SR.Res_result = DL_NoErr Then
cmdStop.Enabled = True
cmdSample.Enabled = False
End If

End Sub

Private Sub cmdStop_Click()
With SR
.Req_op = DL_STOP
.Refresh
End With
If SR.Res_result = DL_NoErr Then
cmdStop.Enabled = False
cmdSample.Enabled = True
End If
End Sub



Private Sub Form_Terminate()
'call code to stop the task just in case it is still running
cmdStop_Click
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

Sub SetupAInonStop()
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_DMA
.Req_subsystem = DL_AO
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_COMMAND  ' stop when Stop Operation is executed
' indeterminate sampling duration (stp on command or trigger) has
' impacts on buffering requirements
.Evt_Tim_type = DL_RATEEVENT ' timing will be used
.Evt_Tim_rateChannel = DL_DEFAULTTIMER  ' each sub-system of board has default timing channel
.Evt_Tim_rateClock = DL_INTERNAL1       ' internal1 timebase
.Evt_Tim_rateGate = DL_NOCONNECT   ' no gating
.Evt_Tim_rateMode = DL_BURSTGEN     ' two updates for each tic of clock
.Evt_Tim_rateOnCount = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 100000) ' how fast to burst
.Evt_Tim_ratePulses = 2   ' how many pulses in the burst
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / (1000)) ' rate at which to write the data
' Select Group
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 2                ' a start channel and stop channel
.Sel_chan_start = 0            ' start on channel 0
.Sel_chan_startGainCode = .DLGain2Code(-1) ' negative = bipolar, 1 = gain of 1
.Sel_chan_stop = 1
.Sel_chan_stopGainCode = .DLGain2Code(-1) 'stop on channel 1
' allocate three buffers of bufSize samples each for the data
.Sel_buf_N = 3                 ' three buffers used
.Sel_buf_samples = bufSize
' when stop condition is command or trigger, must have minimum of 3 buffers
' and the total buffer size should approximate at least 1 second worth of data
'
' the buffer MUST be a multiple of how many channels are in the scan
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
End With
End Sub

Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)

Label2.Caption = "Finished writing buffer #: " & Str(bufIndex)

' could add code to provide new data to the AO buffers here so that
' values could be determined and written "on the fly"

' the BufferFilled message contains the bufIndex that is ready for conversion
'dummy = SR.VBArrayBufferConvert(bufIndex, 0, 8, AIData, DL_tSINGLE, 0, 0)

' for the sample rate, assign buffer size so that BufferFilled messages are not
' sent at a rate faster than is practical for Windows message queue processing,
' e.g., not faster than appx 10 msec rate
End Sub

Private Sub SR_DataLost(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Long, bufElement As Long)
' a Data Lost message could result if buffer size is too small for the
' the requested sample rate
'
MsgBox "Data Lost Message has Occured...try increasing size of or number of buffers", vbOKOnly
'
' could just restart the acquisition from here or take other corrective actions
'With SR
'.Req_op = DL_START
'.Refresh
'End With
End Sub

Private Sub SR_ServiceDone(task As Integer, device As Integer, subsystem As Integer, mode As Integer)
Label2.Caption = "done."
End Sub
